// EditMasterHoliday.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "EditMasterHoliday.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditMasterHoliday dialog


CEditMasterHoliday::CEditMasterHoliday(CWnd* pParent /*=NULL*/)
	: CDialog(CEditMasterHoliday::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditMasterHoliday)
	m_bEveryYear = FALSE;
	m_sName = _T("");
	m_sHolidayID = _T("");
	m_bMaster = TRUE;
	m_sExName = _T("");
	m_lDay = 0;
	m_lMonth = 0;
	m_lYear = 0;
	//}}AFX_DATA_INIT
}
CEditMasterHoliday ::CEditMasterHoliday(IApplication *pApp, BOOL bMaster):CDialog(CEditMasterHoliday::IDD, NULL)
{
	pApplication = pApp;
	m_bMaster = bMaster;
	pMasterHol.CreateInstance(__uuidof(MasterHoliday));
	m_iHolType = 0;

	m_lDay = 0;
	m_lYear = 0;
	m_lMonth = 0;
	
}

void CEditMasterHoliday::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditMasterHoliday)
	DDX_Control(pDX, IDC_CMB_HGID2, m_HGList);
	DDX_Control(pDX, IDC_CMB_ACCT2, m_AcctList);
	DDX_Control(pDX, IDC_COMBO_MASTERHOLIDAYLIST, m_MasterHolList);
	DDX_Check(pDX, IDC_CHECK_EVERYYEAR, m_bEveryYear);
	DDX_Text(pDX, IDC_EDIT_NAME, m_sName);
	DDX_Text(pDX, IDC_EDIT_HOLIDAYID, m_sHolidayID);
	DDX_Text(pDX, IDC_EDIT_HOL_TYPE, m_iHolType);
	DDX_Text(pDX, IDC_EDIT_EX_NAME, m_sExName);
	DDX_Text(pDX, IDC_EDIT_DAY3, m_lDay);
	DDX_Text(pDX, IDC_EDIT_MONTH3, m_lMonth);
	DDX_Text(pDX, IDC_EDIT_YEAR3, m_lYear);
	//}}AFX_DATA_MAP
}

void CEditMasterHoliday :: GetMasterHolDetails()
{
	//select time zone name 
		int index = m_MasterHolList.GetCurSel();
		CString sHolID;
		if(index<0)
			return;

		m_MasterHolList.GetLBText(index,sHolID);
		long lHolID = _wtoi(sHolID);

		
		//BSTR pBstrHolName = sName.AllocSysString();
		_variant_t vMasterHol;
		vMasterHol.Clear();
		if(m_bMaster)
		{
			// Do Nothing
		}
		else
		{
			//CString sHolName = pBstrHolName;
			pApplication->GetHolidayByID(lHolID, &vMasterHol);
		}

		if(vMasterHol.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		if( vMasterHol.vt & VT_DISPATCH)
		{
			
			IMasterHolidayPtr pMasterHol(vMasterHol.pdispVal);
			m_sExName = CString (((LPWSTR)pMasterHol->Name));
			m_sName = m_sExName;

			m_lDay = pMasterHol->Day;
			m_lMonth = pMasterHol->Month;
			m_lYear = pMasterHol->Year;

			
			CString sHolidayID;
			sHolidayID.Format(L"%ld",pMasterHol->MasterHolidayID);
			m_sHolidayID = sHolidayID;
			m_iHolType = pMasterHol->HolidayType;
			m_bEveryYear = pMasterHol->ApplyAllYears;
		}

		UpdateData(FALSE);
		if(NULL != vMasterHol.pdispVal)
		{
			vMasterHol.Clear();
		}
}

BEGIN_MESSAGE_MAP(CEditMasterHoliday, CDialog)
	//{{AFX_MSG_MAP(CEditMasterHoliday)
	ON_CBN_SELCHANGE(IDC_COMBO_MASTERHOLIDAYLIST, OnSelchangeComboMasterholidaylist)
	ON_BN_CLICKED(IDC_BUTTON_EDIT, OnButtonEdit)
	ON_CBN_SELCHANGE(IDC_CMB_ACCT2, OnSelchangeAcctList)
	ON_CBN_SELCHANGE(IDC_CMB_HGID2, OnSelchangeHGlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditMasterHoliday message handlers

BOOL CEditMasterHoliday::OnInitDialog() 
{
	CDialog::OnInitDialog();
	GetDlgItem(IDC_CMB_ACCT2)->EnableWindow(!m_bMaster);
	GetDlgItem(IDC_CMB_HGID2)->EnableWindow(!m_bMaster);

	if(!m_bMaster)
	{
		LoadAccounts();
	}
	else
	{
		// Do Nothing
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEditMasterHoliday::OnSelchangeComboMasterholidaylist() 
{
	GetMasterHolDetails();
}

void CEditMasterHoliday::OnButtonEdit() 
{
	
	BSTR bstrMasterHolName;
	UpdateData(TRUE);
	int index = m_HGList.GetCurSel();
	CString sHGID;
	if(index<0)
		return;
	m_HGList.GetLBText(index,sHGID);
	long lHGID = _wtol(sHGID);
	
	BSTR bstrExHolName = m_sExName.AllocSysString();
	//select account name 
	long lEveryYear = 0;
	long lHolidayType = m_iHolType;
	if(m_bEveryYear == 1)
		lEveryYear = 1;
	
	//get the access level name and description
	bstrMasterHolName = m_sName.AllocSysString();
	
	//set time zone properties
	pMasterHol->ApplyAllYears = lEveryYear;
	pMasterHol->HolidayType = m_iHolType;
	pMasterHol->Name	= bstrMasterHolName;
	
	int accIndex = m_AcctList.GetCurSel();
	if(accIndex<0)
	{
		AfxMessageBox(_T("Account not selected"));
		return;
	}

	//for 4.5 API development
	CString sAcctID;
	m_AcctList.GetLBText(accIndex,sAcctID);
	long lAcctID = _wtoi(sAcctID);
	
	pMasterHol->AccountID = lAcctID;		

	//get the Account Name by AccountID
	BSTR bstrAcctName; 
	pApplication->GetAccountNameByAcctID(lAcctID,&bstrAcctName);
	pMasterHol->AccountName = bstrAcctName;

	try
	{
		pMasterHol->Day = m_lDay;
		pMasterHol->Month = m_lMonth;
		pMasterHol->Year = m_lYear;
	}
	catch(CString errStr)
	{
		AfxMessageBox(errStr);
		return;
	}
	pMasterHol->HolidayGroupID = lHGID;
	
	long lStatus;
	if(m_bMaster)
	{
			// Do Nothing
	}
	else
	{
		pApplication->EditHoliday(bstrExHolName, pMasterHol, &lStatus);
	}

	::SysFreeString(bstrMasterHolName);
	
	
	if(lStatus == 700)
	{
		AfxMessageBox(L"InValid Holiday name");
		return;
	}
	if (lStatus == 701)
	{
		AfxMessageBox(L"Invalid Holiday Name string length");
		return;
	}
	if ( lStatus == 702)
	{
		AfxMessageBox(L"Holiday Name Exists");
		return;
	}
	if (lStatus == 703)
	{
		AfxMessageBox(L"Invalid Holiday type");
		return;
	}
	if (lStatus == 704)
	{
		AfxMessageBox(L"Invalid definition for every year");
		return;
	}
	if (lStatus == 705)
	{
		AfxMessageBox(L"Invalid holiday date");
		return;
	}
	if (lStatus == 706)
	{
		AfxMessageBox(L"Given Holiday does not exist");
		return;
	}
	if (lStatus == 707)
	{
		AfxMessageBox(L"Holiday Name Exists");
		return;
	}
	if (lStatus == 105)
	{
		AfxMessageBox(L"Invalid Account");
		return;
	}
	if (lStatus == 808)
	{
		AfxMessageBox(L"Holiday Date Already in the Holiday Group");
		return;
	}
	if(lStatus == 0)
	{
		AfxMessageBox(L"Holiday Addition succeeded");
		CDialog::OnOK();
	}
	else
	{
		AfxMessageBox(L"Holiday Editing Failed");
		return;
	}

	UpdateData(FALSE);	
}

void CEditMasterHoliday::OnSelchangeAcctList() 
{
	m_HGList.ResetContent();
	LoadHolidayGroups();
}

void CEditMasterHoliday::OnSelchangeHGlist() 
{
	m_MasterHolList.ResetContent();
	LoadHolidays();
}

void CEditMasterHoliday::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			CString sAcctID;
			sAcctID.Format(L"%ld",pAccount->AccountID); 
			m_AcctList.AddString(sAcctID);
			pAccount->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CEditMasterHoliday::LoadHolidayGroups()
{
	int index = m_AcctList.GetCurSel();
	if(index<0)
		return;
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAcctID = _wtoi(sAcctID);

	_variant_t vHolidayGrps;
	vHolidayGrps.Clear();
	pApplication->GetHolidayGroupsByAcctID(lAcctID, &vHolidayGrps);
	
	if(vHolidayGrps.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IHolidayGroup *pHG = NULL;
	
	COleSafeArray sa(vHolidayGrps);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)	
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHolidayGroup,(void**)&pHG);
		if (pHG != NULL)
		{
			CString sHGID;
			sHGID.Format(L"%ld",pHG->HolGrpID);
			m_HGList.AddString(sHGID);
			pHG->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
		
}

void CEditMasterHoliday::LoadHolidays()
{
	int index_HG = m_HGList.GetCurSel();
	if(index_HG<0)
		return;
	CString sHGID;
	m_HGList.GetLBText(index_HG, sHGID);
	long lHGID = _wtoi(sHGID);

	_variant_t vMasterHols;
	vMasterHols.Clear();
	pApplication->GetHolidaysByHolidayGroupID(lHGID, &vMasterHols);
	
	if(vMasterHols.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IMasterHoliday *pMasterHol = NULL;
	
	COleSafeArray sa(vMasterHols);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	m_cMap.RemoveAll();
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IMasterHoliday,(void**)&pMasterHol);
		if (pMasterHol != NULL)
		{
			CString sID;
			sID.Format(_T("%ld"), pMasterHol->MasterHolidayID);
			m_MasterHolList.AddString(sID);
			CString sHolName = (BSTR)pMasterHol->Name; 
			m_cMap[&sHolName] = pMasterHol->MasterHolidayID;
			pMasterHol->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}
